<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

<!-- Item 3 templates -->

	<xsl:template name="Item3">
		<link href="style.css" rel="stylesheet" type="text/css" />
		<div id="maiItem5">
			<div class="contentwrapper">
				<div class="content">
					<h1>Item 3 Residential History</h1>
					<p>Starting with the current address, enter the following information 
					 for all the individual&#180;s residential addresses for the past 5 years. Leave no gaps 
					 greater than three months between addresses. Report changes in an amendment 
					 to this form as they occur in the future. Private residential addresses 
					 will not be included in publicly available versions of this form.</p>
      <h2>Current Address</h2>
	  <div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">From:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:startDate" /> 					
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">To:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:endDate" /> 					
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Street Address 1:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:addressInfo/ns1:street1" /> 					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Street Address 2:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:addressInfo/ns1:street2" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">City:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:addressInfo/ns1:city" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">State/Country:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:addressInfo/ns1:stateOrCountry" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Postal Code:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:residentialHistory/n2:currentAddress/n2:addressInfo/ns1:zipCode" />				
			</div>
		</div><div style="clear:both"></div>   
		</div>
       <xsl:if
			test="(count(n2:residentialHistory/n2:priorAddresses/n2:priorAddress) &gt; 0)">
      <xsl:for-each
			select="n2:residentialHistory/n2:priorAddresses/n2:priorAddress">
	
		<h2>Prior Address</h2>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">From:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:startDate" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">To:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:endDate" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Street Address 1:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/ns1:street1" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Street Address 2:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/ns1:street2" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">City:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/ns1:city" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">State/Country:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/ns1:stateOrCountry" />
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdTwoCol1">Postal Code:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/ns1:zipCode" />
			</div>
		</div><div style="clear:both"></div>
		</div>     
      </xsl:for-each>
      </xsl:if>
    </div>
  </div>
</div>

  
</xsl:template>
</xsl:stylesheet>